// base_xx.cpp : Defines the entry point for the console application.
//

// My objects.
#include "base_64.h"
#include "base_32.h"
#include "base_16.h"

// The other guy's objects.
// #define BUFFERSIZE 16777216
#define BUFFERSIZE 4096
#include "b64/encode.h"
#include "b64/decode.h"

#include <iostream> // for std::cout, possibly other stuff.

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <Windows.h> // For performance counter.
/*
 A very simple performance monitor macro that outputs how quickly the function executed.
 Note that this is WIN32-specific.  I do not know the equivalent functions in POSIX or
 whatever other OS you might be using.
 */
#define PERFMON( doit ) \
	{ \
		LARGE_INTEGER counter, counter_end, frequency; \
		QueryPerformanceFrequency( &frequency ); \
		QueryPerformanceCounter( &counter ); \
		doit; \
		QueryPerformanceCounter( &counter_end ); \
		LARGE_INTEGER diff; \
		diff.QuadPart = ( counter_end.QuadPart - counter.QuadPart ); \
		double fraction = static_cast< double > ( diff.QuadPart / frequency.QuadPart ); \
		std::cout << "Seconds executed: " << diff.QuadPart << "/" << frequency.QuadPart << "ths of a second." << std::endl; \
	}
#else
#define PERFMON( doit ) \
	doit
#endif // WIN32

void separator()
{
	std::cout << "====================================" << std::endl;
}

void header()
{
	std::cout << "------------------------------------" << std::endl;
}

void test_base64()
{
	// This text came from the Wikipedia article on base64, so one may compare the output
	// generated by the encoder against the article's output.  Assuming nobody screws with
	// the article.  Which is kind of tempting for impish people like me.  Heh.
	std::string text( "Man is distinguished, not only by his reason, but by this singular passion from other animals, which is a lust of the mind, that by a perseverance of delight in the continued and indefatigable generation of knowledge, exceeds the short vehemence of any carnal pleasure." );
	std::cout << "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-" << std::endl;
	std::cout << "Testing tvr base_64 encode/decoder..." << std::endl;
	std::cout << "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-" << std::endl;
	std::string result;
	{
		tvr::encode::base_64 _encoder;
		PERFMON( result = _encoder.encode_full( text ) );
		header();
		std::cout << "tvr base_64 encoded:" << std::endl;
		header();
		std::cout << result << std::endl;
	}
	separator();
	{
		tvr::encode::base_64 _encoder( tvr::encode::base_64::get_url_and_filename_safe_alphabet(), 32 );
		PERFMON( result = _encoder.encode_full( text ) );
		header();
		std::cout << "tvr base_64 encoded (linebreaks at 32 chars):" << std::endl;
		header();
		std::cout << result << std::endl;
	}
	separator();
	{
		tvr::decode::base_64 decoder( tvr::decode::base_64::get_url_and_filename_safe_alphabet() );
		std::string test;
		PERFMON( test = decoder.decode_full( result ) );
		header();
		if ( test == text )
		{
			std::cout << "Successfully decoded.\r\n";
		}
		std::cout << "tvr base_64 decoded:" << std::endl;
		header();
		std::cout << decoder.decode_full( result ) << std::endl;
	}
	separator();
	{
		tvr::encode::base_64 encoder;
		std::stringstream out;
		std::stringstream in( text );
		PERFMON( encoder.encode( out, in ) );
		header();
		std::cout << "tvr base_64 encoded using io_streams objects: " << std::endl;
		header();
		std::cout << out.str() << std::endl;
	}
	separator();
	{
		tvr::decode::base_64 decoder;
		std::stringstream in( result );
		std::stringstream out;
		PERFMON( decoder.decode( out, in ) );
		header();
		std::cout << "tvr base_64 decoded using io_streams objects: " << std::endl;
		header();
		std::cout << out.str() << std::endl;
	}
	separator();
	std::cout << "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-" << std::endl;
	std::cout << "Testing original 'C' base64 encode/decoder..." << std::endl;
	std::cout << "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-" << std::endl;
	{
		base64::encoder encoder;
		std::stringstream strm( text );
		std::stringstream res;
		PERFMON( encoder.encode( strm, res ) );
		header();
		std::cout << "Original 'C' base64 encoded:" << std::endl;
		header();
		std::cout << res.str() << std::endl;
	}
	separator();
	{
		base64::decoder decoder;
		std::stringstream in( result );
		std::stringstream out;
		PERFMON( decoder.decode( in, out ) );
		header();
		std::cout << "Original 'C' base64 decoded: " << std::endl;
		header();
		std::cout << out.str() << std::endl;
	}
	separator();
	{
		std::cout << "A slight torture test." << std::endl;
		tvr::encode::base_64 encoder;
		tvr::decode::base_64 decoder;
		PERFMON(
			for ( unsigned int i = 1; i < text.size(); ++i )
			{
				decoder.decode_full( encoder.encode_full( std::string( &text[0], &text[i] ) ) );
			}
		);
		std::cout << "If we did not crash, we were successful." << std::endl;
	}
}

void test_base32()
{
	std::string text( "Man is distinguished, not only by his reason, but by this singular passion from other animals, which is a lust of the mind, that by a perseverance of delight in the continued and indefatigable generation of knowledge, exceeds the short vehemence of any carnal pleasure." );
	std::cout << "Original string:" << std::endl << text << std::endl;
	separator();
	std::string result;
	{
		tvr::encode::base_32 encoder;
		result = encoder.encode_full( "foobar" );
		std::cout << "original: foobar" << std::endl;
		std::cout << "base32 encoded: " << result << std::endl;
	}
	separator();
	{
		tvr::encode::base_32 encoder( tvr::encode::base_32::get_extended_hex_alphabet() );
		result = encoder.encode_full( "foobar" );
		std::cout << "original: foobar" << std::endl;
		std::cout << "base32hex encoded: " << result << std::endl;
	}
	separator();
	{
		tvr::decode::base_32 decoder( tvr::decode::base_32::get_extended_hex_alphabet() );
		std::cout << "original:" << std::endl;
		std::cout << result << std::endl;
		result = decoder.decode_full( result );
		std::cout << "base32hex decoded:" << std::endl;
		std::cout << result << std::endl;
	}
	separator();
	{
		tvr::encode::base_32 encoder;
		PERFMON( result = encoder.encode_full( text ) );
		header();
		std::cout << "base32 encoded: " << std::endl;
		std::cout << result << std::endl;
	}
	separator();
	{
		tvr::decode::base_32 decoder;
		std::cout << "original:" << std::endl;
		std::cout << result << std::endl;
		PERFMON( result = decoder.decode_full( result ) );
		header();
		std::cout << "base32 decoded:" << std::endl;
		std::cout << result << std::endl;
	}
	separator();
	{
		std::cout << "A slight torture test." << std::endl;
		tvr::encode::base_32 encoder;
		tvr::decode::base_32 decoder;
		PERFMON(
			for ( unsigned int i = 1; i < text.size(); ++i )
			{
				decoder.decode_full( encoder.encode_full( std::string( &text[0], &text[i] ) ) );
			}
		);
		std::cout << "If we did not crash, we were successful." << std::endl;
	}
}

void test_base16()
{
	std::string result;
	{
		tvr::encode::base_16 encoder;
		std::cout << "original: foobar" << std::endl;
		header();
		result = encoder.encode_full( "foobar" );
		std::cout << "base16 encoded: " << result << std::endl;
	}
	separator();
	{
		tvr::decode::base_16 decoder;
		std::cout << "original: " << result << std::endl;
		header();
		std::cout << "base16 decoded: " << decoder.decode_full( result ) << std::endl;
	}
	separator();
	std::string text( "Man is distinguished, not only by his reason, but by this singular passion from other animals, which is a lust of the mind, that by a perseverance of delight in the continued and indefatigable generation of knowledge, exceeds the short vehemence of any carnal pleasure." );
	{
		tvr::encode::base_16 encoder;
		std::cout << "original:" << std::endl;
		std::cout << text << std::endl;
		header();
		PERFMON( result = encoder.encode_full( text ) );
		std::cout << "base16 encoded: " << std::endl;
		std::cout << result << std::endl;
	}
	separator();
	{
		tvr::decode::base_16 decoder;
		std::cout << "original:" << std::endl;
		std::cout << result << std::endl;
		header();
		std::string test;
		PERFMON( test = decoder.decode_full( result ) );
		std::cout << "base16 decoded: " << std::endl;
		std::cout << test << std::endl;
	}
	separator();
	{
		std::cout << "A slight torture test." << std::endl;
		tvr::encode::base_16 encoder;
		tvr::decode::base_16 decoder;
		PERFMON(
			for ( unsigned int i = 1; i < text.size(); ++i )
			{
				decoder.decode_full( encoder.encode_full( std::string( &text[0], &text[i] ) ) );
			}
		);
		std::cout << "If we did not crash, we were successful." << std::endl;
	}
}

int main(int argc, char* argv[])
{
	test_base16();
	separator();
	test_base32();
	separator();
	test_base64();
	return 0;
}

