
#include "basic_substring.h"

using namespace std;
using namespace tvr_std;

const char* Gaudy = "gaudy";
const char* Little = "little";
const char* Short = "short";
const char* Stout = "stout";

void testSub(const substring& sub) {
  substring test(sub);
  if (test)
    cout << "Substring \"" << (const string) sub << "\" is valid.";
  else
    cout << "Substring is not valid.";
  cout << endl;
};

int main(int argc, char** argv) {
  string someText("I'm teapot, short and stout.");
  cout << someText << endl;
  substring sub(someText, "teapot");
  testSub(sub);
  sub.prepend("little ");
  testSub(sub);
  cout << someText << endl;
  sub = substring(someText, "I'm");
  testSub(sub);
  sub.append(" a");
  testSub(sub);
  cout << someText << endl;
  sub = substring(someText, Little);
  testSub(sub);
  sub = Gaudy;
  cout << someText << endl;
  sub = substring(someText, Short);
  testSub(sub);
  sub = Gaudy;
  cout << someText << endl;
  sub = substring(someText, Stout);
  testSub(sub);
  sub = Gaudy;
  // By now, the string is "I'm a gaudy teapot, gaudy and gaudy.".
  cout << someText << endl;
  cout << "We're going to change the text back.. first, make 'gaudy' 'little':" << endl;
  sub = substring(someText, Gaudy);
  testSub(sub);
  while (sub) {
     // uses the bool operator to check for validity
     sub = Little;
  }
  cout << "Finished changing text." << endl;
  testSub(sub);
  // Now, the string is "I'm a little teapot, little and little."
  cout << someText << endl;
  sub = substring(someText, Little, true); // reverse substring.
  testSub(sub);
  sub = Stout;
  cout << someText << endl;
  sub = Short;
  // And so, we should be back to "I'm a little teapot, short and stout."
  cout << someText << endl;
  // Testing boundary conditions:
  sub = substring(someText, "I'm");
  sub.prepend("And now, for a quick little poem.\n");
  cout << someText << endl;
  sub = substring(someText, "stout.");
  sub.append("\nThis is my handle, this is my spout.");
  cout << someText << endl;
  exit(0);
};




