// ArchiveEntry.h
//
// Header for ArchiveEntry.

#ifndef ArchiveEntry_H
#define ArchiveEntry_H

#include <dirent.h>
#include <string>
#include <vector>
#include <set>
#include <map>
#include "tag.h"
using namespace std;

// ArchiveEntry
//
// Responsibilities:
//
//   Handles anything having to do with an archival entry (one of the items
//   in the archival index).

const string GetClassText(const string &inVec, const string &classID);

class ArchiveEntry {
public:
	ArchiveEntry();
	ArchiveEntry(const string &aFileName);
	ArchiveEntry(const ArchiveEntry &origEntry);
	~ArchiveEntry();
	const string GetText(); // Acquires the text (used for '<archive latest>' tag.
	const bool operator==(const string &aFileName);
	void operator=(const ArchiveEntry &otherEntry);
	void SetOrder(const string &inVec);
	void SetTitle(const string &inVec);
	void SetPrevLink(const string &inVec);
	void SetNextLink(const string &inVec);
	void SetUpLink(const string &inVec);
	void GetEntryVars(map<string, string> &entryVars);
	friend const bool operator==(const ArchiveEntry &a, const ArchiveEntry &b);
	friend const bool operator<(const ArchiveEntry &a, const ArchiveEntry &b);
	friend ostream &operator<<(ostream &output, const ArchiveEntry &a);
	friend istream &operator>>(istream &input, ArchiveEntry &a);
	friend int sortByTitle(const void *a, const void *b);
	friend int sortByOrderTag(const void *a, const void *b);
	static string prevClassID;
	static string nextClassID;
	static string upClassID;
	static void GetPrefFile(const string &inPrefFile);
	static void SetPrefFile(const string &inPrefFile);
	const string GetLatest(const string &latestID);
	string fileName;  // Name of the archival entry file.
private:
	void init(){};
	string order;     // A string taken from the <archive order=""> tag.
	string title;     // A string taken from the <title>???</title> tag.
	string prevLink;  // The text to use for the previous item link.
	string nextLink;  // The text to use for the next item link.
	string upLink;    // The text to use for the link to the index file.
	string::iterator begin; // Start of text we want to extract.
	string::iterator end;   // end of text we want to extract for latest.
	time_t m_time;    // Modification time.
};

const bool operator==(const ArchiveEntry &a, const ArchiveEntry &b);
const bool operator<(const ArchiveEntry &a, const ArchiveEntry &b);
ostream &operator<<(ostream &output, const ArchiveEntry &a);
istream &operator>>(istream &input, ArchiveEntry &a);

extern set<ArchiveEntry> listItems;
extern string _ArchiveEntryPath;

int sortByTitle(const void *a, const void *b);
int sortByOrderTag(const void *a, const void *b);

#define SAFEHTMLSTART() try {
#define SAFEHTMLSTOP() } catch(Exception error){}


#endif // ArchiveEntry_H

// vim:ai ts=4
