// ArchiveTag
// 
// Responsibilities:
//
//  Holds information gathered from the <archive> tag in a template file.

#ifndef ArchiveTag_H
#define ArchiveTag_H

#include <string>
#include <map>
#include "ArchiveEntry.h"
#include "tag.h"
#include "Dir.h"

class ArchiveTag {
public:
	enum eSortType {
		eModificationDate,
		eCreationDate,
		eFilename,
		eOrderTag,
		eTitle
	};
	ArchiveTag() {nextTag = 0; init();};
	ArchiveTag(HTMLTag &tag);
	~ArchiveTag(){delete nextTag;};
	void operator=(HTMLTag &tag);
	void SetNext(ArchiveTag *next) {nextTag = next;};
	void GetXY(unsigned long int &x, unsigned long int &y);
	void WriteFile(const string &output);
	string GetIndex();
	string GetLatest();
private:
	void DoForeExec();
	void DoPostExec();
	map<string, string> GetListVars();
	void CreateForeList(string &output);
	void CreatePostList(string &output);
	map<string, string> GetGroupVars();
	void CreateForeGroup(string &output);
	void CreatePostGroup(string &output);
	map<string, string> GetEntryVars();
	void CreateForeEntry(string &output);
	void CreatePostEntry(string &output);
	void determineSortType(const string &sortString);
	void createArchiveEntries();
	void init();
	string archiveFileName;  // the name of the file holding the tag.
	string outboundFileName; // name of the file to be written.
	bool isIndex;            // indicates whether or not this is an index.
	string latestID;    // if set, indicates that text within this class id
	                    // should be used for the latest text to display in
						// place of the ARCHIVE tag.
	string nextIndex;    // the next index file to archive.
	string latestText;       // text taken from the latest archival entry.
	eSortType sortType;      // indicates how to sort the entries.
	string prevLink;         // raw text for the previous link.
	string prevLinkClass;    // text to look for (that is, <div class="?">
	string nextLink;         // raw text for the next link.
	string nextLinkClass;    // text to look for (that is, <div class="?">
	string upLinkClass;      // text to look for (that is, <div class="?">
	string noPrevious;       // text to insert for no previous link.
	string noNext;           // text to insert for no next link.
	string foreExec;         // command to run before handling archive.
	string postExec;         // command to run after handling archive.
	vector<ArchiveEntry> archiveEntries; // a vector of archive entries.
	ArchiveTag *nextTag;      // the next ArchiveTag in the current file.
	// Columnar vars...
	string foreList;		// Text to insert prior to making out the list.
	string foreGroup;       // Text to insert prior to making a grouping.
	string foreEntry;       // Text to insert prior to making an entry.
	string entryText;       // Text to use for the actual entry.
	string postEntry;       // Text to insert after making an entry.
	string postGroup;       // Text to insert after making a grouping.
	string postList;		// Text to insert after making out the list.
	// Directory information..
	Dir entryPath;        // The directory for the entries..
	Dir outboundPath;     // The directory for the outbound file.
	// Columnar limits...
	unsigned long int maxCol;
	unsigned long int minCol;
};

#endif // ArchiveTag_H
// vim:ai ts=4
