
#ifndef DIR_H_SLALSKDLASDFAJWEPOKAJHSDLKHJASKDHALKJDFHLA
#define DIR_H_SLALSKDLASDFAJWEPOKAJHSDLKHJASKDHALKJDFHLA

#include <string>

using namespace std;

// Dir
//
// Responsibilities:
//   Handles operations related to directories (in a virtual way).
class Dir {
public:
	Dir();
	Dir(const string &newPath);
	Dir(const Dir &inDir) {*this = inDir;};
	~Dir() {};
	void operator=(const Dir &inDir);
	operator string();
	const string cd(const string &absPath);
	const string GetPathRelativeTo(const string &absPath) const;
	const string GetPathRelativeTo(const Dir &absPath) const;
	const string GetPathRelativeFrom(const string &absPath) const;
	const string GetPathRelativeFrom(const Dir &absPath) const;
	static const string GetAbsPath(const string &relPath);
	static const string GetHome();
	static Dir getcwd();
	static void SetVirtualCWD(Dir *virtCWD) {delete virtualCWD; virtualCWD = virtCWD;};
private:
	static Dir *virtualCWD;
	bool isRelative(const string &aPath);
	string path;
};

#endif // DIR_H_SLALSKDLASDFAJWEPOKAJHSDLKHJASKDHALKJDFHLA

// vim:ai ts=4
