// htmlArc.cpp
// Implementation file.

#include "HTMLArchive.h"
#include "ArchiveTag.h"
#include "misc.h"
#include <iostream>
#include <fstream>

using namespace std;

// HTMLArchive implementation

HTMLArchive::HTMLArchive() {
}

HTMLArchive::~HTMLArchive() {
}

const string HTMLArchive::getPrefFilePath(const string &filePath) {
	if (filePath.empty()) {
		return string(); // nothing to do.
	}
	string output;
	string path;
	string file;
	splitFilePath(filePath, file, path);
	file = "." + file;
	if (path.empty()) {
		path = ".";
	}
	// Separate the directory and the file path.
	Dir dirPath(path);
	output = (string)dirPath + file;
	return output;
}

int HTMLArchive::Archive(const char *fileName) {
	if (fileName == 0) {
		// Nothing to do.
		cerr << "Filename wasn't specified.\n" << endl;
		return 1;
	}
	string output;
	string prefFile = getPrefFilePath(fileName);
	ArchiveEntry::GetPrefFile(prefFile);
	string archiveFileText;
	if (strcmp(fileName, "-")==0) {
		// Use stdin for file.
		while (!cin.eof()) {
			char ch;
			cin.get(ch);
			archiveFileText += ch;
		}
	} else {
		// Let's try to open the file.
		//
		// NOTE: if fileName starts with '-' we need to strip the first
		// one off.  This is to allow users to specify a fileName of '-'
		// that doesn't refer to the standard io.
		string incomingFile;
		if (fileName[0]=='-') {
			incomingFile = &fileName[1];
		} else {
			incomingFile = fileName;
		}
		string curDir;
		string file;
		splitFilePath(incomingFile, file, curDir );
		// This should set the virtual current directory to the same as the
		// Archive file.  Any previous setting will be removed.
		if (!curDir.empty()) {
			Dir::SetVirtualCWD(new Dir(curDir));
		}
		ifstream inFile(incomingFile.c_str(), ios::in | ios::binary);
		if (!inFile.is_open()) {
			cerr << "Unable to open " << incomingFile << " for reading." << endl;
			return 1;
		}
		// Now we want to copy the contents of the file into a vector, so
		// we can work with it more easily.
		cerr << "File: [" << fileName << "]." << endl;
		while (!inFile.eof()) {
			char ch;
			inFile.get(ch);
			archiveFileText += ch;
		}
	}
	// Now, let's see if we can find the archive tag(s)...
	unsigned int foundOne = 0;
	string::iterator found = archiveFileText.begin();
	string::iterator beginning = found;
	string archiveTag("<archive");
	ArchiveTag *start = 0, *next = 0;
	while (found != archiveFileText.end()) {
		// Thus starts our search for archive tags...
		found = search(found, archiveFileText.end(), archiveTag.begin(), archiveTag.end(), no_case);
		if (found == archiveFileText.end() && foundOne==0) {
			// didn't have the tag.
			cerr << "File \"" << fileName << "\" does not have an <ARCHIVE> tag." << endl;
			return 1;
		}
		if (found == archiveFileText.end()) {
			// We have finished with this file.  We'll tell the user about it,
			// try to create all our requisit whatnot, then save our
			// preferences file, and return whatever error codes we gained
			// during our data wranglings.
			cerr << "Finished with \"" << fileName << "\"." << endl;
			cerr << "Found " << foundOne << " <ARCHIVE> tag";
			if (foundOne < 2 ) {
				cerr << "." << endl;
			} else {
				cerr << "s." << endl;
			}
			output += string(beginning, found);
			start->WriteFile(output);
			ArchiveEntry::SetPrefFile(prefFile);
			return 0;
		}
		// Okay, we've found the archive tag, now we need to fill an archive
		// tag object.
		cerr << "<ARCHIVE>" << endl;
		HTMLTag archiveHTMLTag(found, archiveFileText.end());
		ArchiveTag *curArchiveTag = new ArchiveTag(archiveHTMLTag);
		output += string(beginning, found);
		output += curArchiveTag->GetIndex();
		output += curArchiveTag->GetLatest();
		found = archiveHTMLTag.end()+1;
		beginning = found;
		if (start) {
			next->SetNext(curArchiveTag);
			next = curArchiveTag;
		} else {
			start = curArchiveTag;
			next = curArchiveTag;
		}
		++foundOne;
	}
}

// vim:ai ts=4
