
// error.cpp
//
// Implementation file for error (exception) handling.

#include "error.h"

Exception *Exception::error = 0;

const string ArchiveError::message() {
	string errString("Archive error: ");
	switch (error) {
	case eNoError:
		errString += "No error.";
		break;
	case eNoOutboundFile:
		errString += "Outbound filename not specified.";
		break;
	case eNoOpenOutboundFile:
		errString += "Unable to open outbound file.";
		break;
	case eNoOpenEntry:
		errString += "Unable to open latest entry.";
		break;
	default:
		errString += "Unknown error.";
	}
	return errString;
}


