
// error.h
//
// Header file for error (exception) handling.

#ifndef HTMLARCHIVE_ERROR_H
#define HTMLARCHIVE_ERROR_H

#include <string>

// Exception
//
// Abstract base class for exceptions.

class Exception {
public:
	Exception() {};
	virtual ~Exception() {};
	virtual const string message() {return string("Unknown exception.");};
	static Exception *error;
};

class ArchiveError : public Exception {
public:
	enum eErrorType {
		eNoError = 0,
		eNoOutboundFile,
		eNoOpenOutboundFile,
		eNoOpenEntry
	};
	ArchiveError() {Exception::error = this;};
	ArchiveError(eErrorType errorType) {error = errorType; Exception::error = this;};
	virtual ~ArchiveError() {};
	void operator=(const eErrorType errorType) {error = errorType;};
	void operator=(const ArchiveError &errorType) {error = errorType.error;};
	bool operator==(const eErrorType errorType) {return errorType == error;};
	bool operator==(const ArchiveError &errorType) {return errorType.error == error;};
	virtual const string message();
private:
	eErrorType error;
};

#endif // HTMLARCHIVE_ERROR_H
