
#include "HTMLArchive.h"
#include "ArchiveEntry.h"
#include "Dir.h"
#include <locale.h>

#define USAGE() cerr << "usage: "<< PACKAGE << " [-v] file [anotherFile [yetAnotherFile [...]]]" << endl << "Consult docs for more details." << endl;


int main(int argc, char *argv[]) {
	int error = 0;
	setlocale(LC_ALL, ""); // so case-comparison works appropriately.
	HTMLArchive archiveHandler;
	if (argc < 2) {
		// User probably doesn't know how this works.
		USAGE()
		exit(1);
	}
	if (strcmp(argv[1], "-v")==0) {
		cerr << argv[0] << ": Version " << VERSION << endl;
		USAGE()
		exit(0);
	}
	try {
		for (int i = 1; i < argc; i++) {
			string prefFile(argv[i]);
			int curError = archiveHandler.Archive(argv[i]);
			if (curError) {
				cerr << "error handling \"" << argv[i] << "\"\n";
				error = curError;
			}
		}
	} catch (ArchiveError error) {
		cerr << error.message() << endl;
	}
	Dir::SetVirtualCWD(0); // cleanup, in case this was set.
	return error;
}
// vim:ai ts=4
