// tag.h
// Header file

// Header for anything having to do with the parsing of HTML tags and
// attributes.

#ifndef TAG_H
#define TAG_H

#include <iterator>
#include <vector>
#include <algorithm>
#include <string>
#include "error.h"

using namespace std;

class HTMLTagError : public Exception {
public:
	enum eErrorType {
		eNoError = 0,
		eNoSuchAttribute
	};
	HTMLTagError() {};
	HTMLTagError(eErrorType errorType) {error = errorType;};
	virtual ~HTMLTagError() {};
	void operator=(const eErrorType errorType) {error = errorType;};
	void operator=(const HTMLTagError &errorType) {error = errorType.error;};
	bool operator==(const eErrorType errorType) {return errorType == error;};
	bool operator==(const HTMLTagError &errorType) {return errorType.error == error;};
	virtual const string message();
private:
	eErrorType error;
};


bool operator==(const class HTMLTagAttribute &a, const class HTMLTagAttribute &b);
bool operator<(const class HTMLTagAttribute &a, const class HTMLTagAttribute &b);

class HTMLTagAttribute {
public:
	HTMLTagAttribute();
	HTMLTagAttribute(const string &inName);
	HTMLTagAttribute(const string &inName, const string &inValue);
	HTMLTagAttribute(const HTMLTagAttribute &attrib);
	~HTMLTagAttribute();
	HTMLTagAttribute &operator=(const HTMLTagAttribute &attrib);
	const string &GetName() {return name;};
	const string &GetValue() {return value;};
	static void clean(string &inString);
	friend bool operator==(const HTMLTagAttribute &a, const HTMLTagAttribute &b);
	friend bool operator<(const HTMLTagAttribute &a, const HTMLTagAttribute &b);
private:
	string name;
	string value;
};

class HTMLTag {
public:
	HTMLTag();
	HTMLTag(const string::iterator &begin, const string::iterator &end);
	HTMLTag(const HTMLTag &origTag);
	~HTMLTag();
	HTMLTagAttribute &GetAttribute(const string &attribute);
	const bool operator==(const HTMLTag &origTag);
	HTMLTag &operator=(const HTMLTag &origTag);
	const string::iterator &end() {return tagEnd;};
	const string::iterator &GetTextEnd();
	const string &GetTag() {return tag;};
private:
	const string::iterator ParseAttribute(const string::iterator &start, const string::iterator &end);
	string tag;
	vector<HTMLTagAttribute> attributes;
	string::iterator tagEnd;
	string::iterator textEnd;
};

class HTMLTagContainer {
public:
	HTMLTagContainer();
	HTMLTagContainer(const HTMLTag &newTag);
	HTMLTagContainer(const HTMLTagContainer &origTag);
	const bool operator==(const HTMLTagContainer &origTag);
	HTMLTagContainer &operator=(const HTMLTagContainer &origTag);
	~HTMLTagContainer();
	const string::iterator &end() {return tagEnd;};
	const string::iterator &begin() {return tag.end();};
private:
	HTMLTag tag;
	string contents;
	string::iterator tagEnd;
};

const string::iterator skipNotSet(
	const string::iterator &start,
	const string::iterator &end,
	const string &charSet
);

const string::iterator skipSet(
	const string::iterator &start,
	const string::iterator &end,
	const string &charSet
);

const string::iterator skipValue(
	const string::iterator &start,
	const string::iterator &end
);

const string::iterator skipWhiteSpace(
	const string::iterator &start,
	const string::iterator &end
);

const string::iterator skipNonWhiteSpace(
	const string::iterator &start,
	const string::iterator &end
);

const string::iterator skipEndTag(
	const string::iterator &start,
	const string::iterator &end,
	const string &tag
);

const string makeString(const string &inVec);

bool no_case_compare(const string &a, const string &b);

bool no_case(const char &a, const char &b);

#endif // TAG_H
// vim:ai ts=4
